﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class StudentDoc : PI.FM.N000.Base.BL.DBD.BaseTable<BO.StudentDoc>
    {
        #region Static factory
        private static StudentDoc _factory = null;

        public static StudentDoc DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new StudentDoc();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_StudentDoc";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("StudentID", "StudentID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Path", "Path"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Flags", "Flags"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreByStudentID = 10,
            RestoreByStudentIDName = 11,
            RemoveByStudentID = 12
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreByStudentID: return new Command_RestoreByStudentID();
                case (int)Commands.RestoreByStudentIDName: return new Command_RestoreByStudentIDName();
                case (int)Commands.RemoveByStudentID: return new Command_RemoveByStudentID();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreByStudentID : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.StudentDoc>
        {
            public Command_RestoreByStudentID() : base(PI.ZB.N1200.ELearning.BL.DBD.StudentDoc.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_StudentDoc_RestoreByStudentID";
            }
        }
        class Command_RestoreByStudentIDName : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.StudentDoc>
        {
            public Command_RestoreByStudentIDName() : base(PI.ZB.N1200.ELearning.BL.DBD.StudentDoc.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Name", Gemini.Core.BL.DAL.SqlTypes.VarChar));                
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_StudentDoc_RestoreByStudentIDName";
            }
        }

        class Command_RemoveByStudentID : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Student>
        {
            public Command_RemoveByStudentID() : base(PI.ZB.N1200.ELearning.BL.DBD.Student.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("EditDate", Gemini.Core.BL.DAL.SqlTypes.DateTime));
                Add(new Gemini.Core.BL.DBD.Param("EditUser", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_StudentDoc_RemoveByStudentID";
            }
        }
        #endregion
    }
}